/*!
*******************************************************************************
* \file             spi_tclMySpinVrStream.cpp
* \brief            Copy audio data from an ALSA source to an ALSA sink
*******************************************************************************
\verbatim
PROJECT:        Gen3 Projects
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Copy audio data from an ALSA source to an ALSA sink
COPYRIGHT:      &copy; BSOT

HISTORY:
Date       |  Author                          | Modifications
08.10.2015 |  Tobias Quintern (BSOT/ENG)      | Initial version
05.01.2016 |  Tobias Quintern (BSOT/ENG)      | Changed public interface for increased flexibility

\endverbatim
******************************************************************************/





/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include "mspin_vr_stream.h"
#include "spi_tclMySpinVrStream.h"
#include "mspin_logging.h"
#ifdef USE_GENERATED_MYSPIN_VERSION_FILE
#include "mspin_version.h"
#endif

MySpinVrStream::MySpinVrStream() :
m_poMySpinVrStream(NULL)
{
   m_poMySpinVrStream = new spi_tclMySpinVrStream();

   if( NULL == m_poMySpinVrStream )
   {
      mspin_log_printLn(eMspinVerbosityFatal, "%s() "
            "Creation of spi_tclMySpinVrStream failed.",__PRETTY_FUNCTION__ );
   }
}

MySpinVrStream::~MySpinVrStream()
{
   if( NULL != m_poMySpinVrStream )
   {
      delete m_poMySpinVrStream;
      m_poMySpinVrStream = NULL;
   }
}

S32 MySpinVrStream::startVrStream( const vrDeviceConfig captureDeviceConfig ,
                                       const vrDeviceConfig playbackDeviceConfig ,
                                       const snd_pcm_access_t spaAccess ,
                                       const snd_pcm_format_t spfFormat ,
                                       const unsigned int channels ,
                                       const unsigned int samplerate)
{
   S32 retVal = -1;

   if( NULL != m_poMySpinVrStream )
   {
#ifdef MYSPIN_GIT_VERSION
      mspin_log_printLn(eMspinVerbosityInfo,
            "%s() mySpin AudioStreamLib version %s", __FUNCTION__, MYSPIN_GIT_VERSION); //print version info
#else
      mspin_log_printLn(eMspinVerbosityInfo,
            "%s() mySPIN AudioStreamLib version %s", __FUNCTION__, "n/a"); //Git version not available
#endif //#ifdef MYSPIN_GIT_VERSION

      retVal = m_poMySpinVrStream->s32StartVRStream(  captureDeviceConfig,
                                            playbackDeviceConfig,
                                            spaAccess,
                                            spfFormat,
                                            channels,
                                            samplerate);
   }

   return(retVal);
}

S32 MySpinVrStream::stopVrStream()
{
   S32 retVal = -1;

   if( NULL != m_poMySpinVrStream )
   {
      retVal = m_poMySpinVrStream->s32StopVrStream();
   }

   return(retVal);
}

void MySpinVrStream::registerCallbacks(U32 context , vrStreamCallbacks vrCallbacks)
{
   if( NULL != m_poMySpinVrStream )
   {
      m_poMySpinVrStream->vRegisterCallbacks(context, vrCallbacks);
   }
}
